#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
# Don't mess with /etc/drirc. Mesa now installs the defaults as
# /usr/share/drirc.d/00-mesa-defaults.conf. We won't protect that
# as a .new file as it shouldn't be modified. Create /etc/drirc if
# you need local overrides.
#config etc/drirc.new
( cd usr/lib64/dri ; rm -rf apple_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so apple_dri.so )
( cd usr/lib64/dri ; rm -rf armada-drm_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so armada-drm_dri.so )
( cd usr/lib64/dri ; rm -rf crocus_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so crocus_dri.so )
( cd usr/lib64/dri ; rm -rf d3d12_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so d3d12_dri.so )
( cd usr/lib64/dri ; rm -rf d3d12_drv_video.so )
( cd usr/lib64/dri ; ln -sf ../libgallium-25.3.0-rc2.so d3d12_drv_video.so )
( cd usr/lib64/dri ; rm -rf exynos_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so exynos_dri.so )
( cd usr/lib64/dri ; rm -rf gm12u320_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so gm12u320_dri.so )
( cd usr/lib64/dri ; rm -rf hdlcd_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so hdlcd_dri.so )
( cd usr/lib64/dri ; rm -rf hx8357d_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so hx8357d_dri.so )
( cd usr/lib64/dri ; rm -rf i915_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so i915_dri.so )
( cd usr/lib64/dri ; rm -rf ili9163_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so ili9163_dri.so )
( cd usr/lib64/dri ; rm -rf ili9225_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so ili9225_dri.so )
( cd usr/lib64/dri ; rm -rf ili9341_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so ili9341_dri.so )
( cd usr/lib64/dri ; rm -rf ili9486_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so ili9486_dri.so )
( cd usr/lib64/dri ; rm -rf imx-dcss_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so imx-dcss_dri.so )
( cd usr/lib64/dri ; rm -rf imx-drm_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so imx-drm_dri.so )
( cd usr/lib64/dri ; rm -rf imx-lcdif_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so imx-lcdif_dri.so )
( cd usr/lib64/dri ; rm -rf ingenic-drm_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so ingenic-drm_dri.so )
( cd usr/lib64/dri ; rm -rf iris_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so iris_dri.so )
( cd usr/lib64/dri ; rm -rf kirin_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so kirin_dri.so )
( cd usr/lib64/dri ; rm -rf kms_swrast_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so kms_swrast_dri.so )
( cd usr/lib64/dri ; rm -rf komeda_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so komeda_dri.so )
( cd usr/lib64/dri ; rm -rf mali-dp_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so mali-dp_dri.so )
( cd usr/lib64/dri ; rm -rf mcde_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so mcde_dri.so )
( cd usr/lib64/dri ; rm -rf mediatek_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so mediatek_dri.so )
( cd usr/lib64/dri ; rm -rf meson_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so meson_dri.so )
( cd usr/lib64/dri ; rm -rf mi0283qt_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so mi0283qt_dri.so )
( cd usr/lib64/dri ; rm -rf mxsfb-drm_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so mxsfb-drm_dri.so )
( cd usr/lib64/dri ; rm -rf nouveau_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so nouveau_dri.so )
( cd usr/lib64/dri ; rm -rf nouveau_drv_video.so )
( cd usr/lib64/dri ; ln -sf ../libgallium-25.3.0-rc2.so nouveau_drv_video.so )
( cd usr/lib64/dri ; rm -rf panel-mipi-dbi_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so panel-mipi-dbi_dri.so )
( cd usr/lib64/dri ; rm -rf pl111_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so pl111_dri.so )
( cd usr/lib64/dri ; rm -rf r300_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so r300_dri.so )
( cd usr/lib64/dri ; rm -rf r600_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so r600_dri.so )
( cd usr/lib64/dri ; rm -rf r600_drv_video.so )
( cd usr/lib64/dri ; ln -sf ../libgallium-25.3.0-rc2.so r600_drv_video.so )
( cd usr/lib64/dri ; rm -rf radeonsi_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so radeonsi_dri.so )
( cd usr/lib64/dri ; rm -rf radeonsi_drv_video.so )
( cd usr/lib64/dri ; ln -sf ../libgallium-25.3.0-rc2.so radeonsi_drv_video.so )
( cd usr/lib64/dri ; rm -rf rcar-du_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so rcar-du_dri.so )
( cd usr/lib64/dri ; rm -rf repaper_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so repaper_dri.so )
( cd usr/lib64/dri ; rm -rf rockchip_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so rockchip_dri.so )
( cd usr/lib64/dri ; rm -rf rzg2l-du_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so rzg2l-du_dri.so )
( cd usr/lib64/dri ; rm -rf ssd130x_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so ssd130x_dri.so )
( cd usr/lib64/dri ; rm -rf st7586_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so st7586_dri.so )
( cd usr/lib64/dri ; rm -rf st7735r_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so st7735r_dri.so )
( cd usr/lib64/dri ; rm -rf sti_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so sti_dri.so )
( cd usr/lib64/dri ; rm -rf stm_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so stm_dri.so )
( cd usr/lib64/dri ; rm -rf sun4i-drm_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so sun4i-drm_dri.so )
( cd usr/lib64/dri ; rm -rf swrast_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so swrast_dri.so )
( cd usr/lib64/dri ; rm -rf udl_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so udl_dri.so )
( cd usr/lib64/dri ; rm -rf virtio_gpu_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so virtio_gpu_dri.so )
( cd usr/lib64/dri ; rm -rf virtio_gpu_drv_video.so )
( cd usr/lib64/dri ; ln -sf ../libgallium-25.3.0-rc2.so virtio_gpu_drv_video.so )
( cd usr/lib64/dri ; rm -rf vkms_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so vkms_dri.so )
( cd usr/lib64/dri ; rm -rf vmwgfx_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so vmwgfx_dri.so )
( cd usr/lib64/dri ; rm -rf zink_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so zink_dri.so )
( cd usr/lib64/dri ; rm -rf zynqmp-dpsub_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so zynqmp-dpsub_dri.so )
( cd usr/lib64 ; rm -rf libEGL_mesa.so )
( cd usr/lib64 ; ln -sf libEGL_mesa.so.0 libEGL_mesa.so )
( cd usr/lib64 ; rm -rf libEGL_mesa.so.0 )
( cd usr/lib64 ; ln -sf libEGL_mesa.so.0.0.0 libEGL_mesa.so.0 )
( cd usr/lib64 ; rm -rf libGLX_mesa.so )
( cd usr/lib64 ; ln -sf libGLX_mesa.so.0 libGLX_mesa.so )
( cd usr/lib64 ; rm -rf libGLX_mesa.so.0 )
( cd usr/lib64 ; ln -sf libGLX_mesa.so.0.0.0 libGLX_mesa.so.0 )
( cd usr/lib64 ; rm -rf libGLX_system.so.0 )
( cd usr/lib64 ; ln -sf libGLX_mesa.so.0 libGLX_system.so.0 )
( cd usr/lib64 ; rm -rf libRusticlOpenCL.so )
( cd usr/lib64 ; ln -sf libRusticlOpenCL.so.1 libRusticlOpenCL.so )
( cd usr/lib64 ; rm -rf libRusticlOpenCL.so.1 )
( cd usr/lib64 ; ln -sf libRusticlOpenCL.so.1.0.0 libRusticlOpenCL.so.1 )
( cd usr/lib64 ; rm -rf libgbm.so )
( cd usr/lib64 ; ln -sf libgbm.so.1 libgbm.so )
( cd usr/lib64 ; rm -rf libgbm.so.1 )
( cd usr/lib64 ; ln -sf libgbm.so.1.0.0 libgbm.so.1 )
( cd usr/lib64 ; rm -rf libglapi.so.0 )
( cd usr/lib64 ; ln -sf libglapi.so.0.0.0 libglapi.so.0 )
