#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
# Don't mess with /etc/drirc. Mesa now installs the defaults as
# /usr/share/drirc.d/00-mesa-defaults.conf. We won't protect that
# as a .new file as it shouldn't be modified. Create /etc/drirc if
# you need local overrides.
#config etc/drirc.new
( cd usr/lib64/dri ; rm -rf crocus_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so crocus_dri.so )
( cd usr/lib64/dri ; rm -rf d3d12_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so d3d12_dri.so )
( cd usr/lib64/dri ; rm -rf d3d12_drv_video.so )
( cd usr/lib64/dri ; ln -sf ../libgallium-25.2.6.so d3d12_drv_video.so )
( cd usr/lib64/dri ; rm -rf i915_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so i915_dri.so )
( cd usr/lib64/dri ; rm -rf iris_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so iris_dri.so )
( cd usr/lib64/dri ; rm -rf kms_swrast_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so kms_swrast_dri.so )
( cd usr/lib64/dri ; rm -rf nouveau_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so nouveau_dri.so )
( cd usr/lib64/dri ; rm -rf nouveau_drv_video.so )
( cd usr/lib64/dri ; ln -sf ../libgallium-25.2.6.so nouveau_drv_video.so )
( cd usr/lib64/dri ; rm -rf r300_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so r300_dri.so )
( cd usr/lib64/dri ; rm -rf r600_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so r600_dri.so )
( cd usr/lib64/dri ; rm -rf r600_drv_video.so )
( cd usr/lib64/dri ; ln -sf ../libgallium-25.2.6.so r600_drv_video.so )
( cd usr/lib64/dri ; rm -rf radeonsi_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so radeonsi_dri.so )
( cd usr/lib64/dri ; rm -rf radeonsi_drv_video.so )
( cd usr/lib64/dri ; ln -sf ../libgallium-25.2.6.so radeonsi_drv_video.so )
( cd usr/lib64/dri ; rm -rf swrast_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so swrast_dri.so )
( cd usr/lib64/dri ; rm -rf virtio_gpu_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so virtio_gpu_dri.so )
( cd usr/lib64/dri ; rm -rf virtio_gpu_drv_video.so )
( cd usr/lib64/dri ; ln -sf ../libgallium-25.2.6.so virtio_gpu_drv_video.so )
( cd usr/lib64/dri ; rm -rf vmwgfx_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so vmwgfx_dri.so )
( cd usr/lib64/dri ; rm -rf zink_dri.so )
( cd usr/lib64/dri ; ln -sf libdril_dri.so zink_dri.so )
( cd usr/lib64 ; rm -rf libEGL_mesa.so )
( cd usr/lib64 ; ln -sf libEGL_mesa.so.0 libEGL_mesa.so )
( cd usr/lib64 ; rm -rf libEGL_mesa.so.0 )
( cd usr/lib64 ; ln -sf libEGL_mesa.so.0.0.0 libEGL_mesa.so.0 )
( cd usr/lib64 ; rm -rf libGLX_mesa.so )
( cd usr/lib64 ; ln -sf libGLX_mesa.so.0 libGLX_mesa.so )
( cd usr/lib64 ; rm -rf libGLX_mesa.so.0 )
( cd usr/lib64 ; ln -sf libGLX_mesa.so.0.0.0 libGLX_mesa.so.0 )
( cd usr/lib64 ; rm -rf libGLX_system.so.0 )
( cd usr/lib64 ; ln -sf libGLX_mesa.so.0 libGLX_system.so.0 )
( cd usr/lib64 ; rm -rf libRusticlOpenCL.so )
( cd usr/lib64 ; ln -sf libRusticlOpenCL.so.1 libRusticlOpenCL.so )
( cd usr/lib64 ; rm -rf libRusticlOpenCL.so.1 )
( cd usr/lib64 ; ln -sf libRusticlOpenCL.so.1.0.0 libRusticlOpenCL.so.1 )
( cd usr/lib64 ; rm -rf libgbm.so )
( cd usr/lib64 ; ln -sf libgbm.so.1 libgbm.so )
( cd usr/lib64 ; rm -rf libgbm.so.1 )
( cd usr/lib64 ; ln -sf libgbm.so.1.0.0 libgbm.so.1 )
( cd usr/lib64 ; rm -rf libglapi.so.0 )
( cd usr/lib64 ; ln -sf libglapi.so.0.0.0 libglapi.so.0 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_d3d12.so )
( cd usr/lib64/vdpau ; ln -sf libvdpau_d3d12.so.1.0.0 libvdpau_d3d12.so )
( cd usr/lib64/vdpau ; rm -rf libvdpau_d3d12.so.1 )
( cd usr/lib64/vdpau ; ln -sf libvdpau_d3d12.so.1.0.0 libvdpau_d3d12.so.1 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_d3d12.so.1.0 )
( cd usr/lib64/vdpau ; ln -sf libvdpau_d3d12.so.1.0.0 libvdpau_d3d12.so.1.0 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_d3d12.so.1.0.0 )
( cd usr/lib64/vdpau ; ln -sf ../libgallium-25.2.6.so libvdpau_d3d12.so.1.0.0 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_nouveau.so )
( cd usr/lib64/vdpau ; ln -sf libvdpau_nouveau.so.1.0.0 libvdpau_nouveau.so )
( cd usr/lib64/vdpau ; rm -rf libvdpau_nouveau.so.1 )
( cd usr/lib64/vdpau ; ln -sf libvdpau_nouveau.so.1.0.0 libvdpau_nouveau.so.1 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_nouveau.so.1.0 )
( cd usr/lib64/vdpau ; ln -sf libvdpau_nouveau.so.1.0.0 libvdpau_nouveau.so.1.0 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_nouveau.so.1.0.0 )
( cd usr/lib64/vdpau ; ln -sf ../libgallium-25.2.6.so libvdpau_nouveau.so.1.0.0 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_r600.so )
( cd usr/lib64/vdpau ; ln -sf libvdpau_r600.so.1.0.0 libvdpau_r600.so )
( cd usr/lib64/vdpau ; rm -rf libvdpau_r600.so.1 )
( cd usr/lib64/vdpau ; ln -sf libvdpau_r600.so.1.0.0 libvdpau_r600.so.1 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_r600.so.1.0 )
( cd usr/lib64/vdpau ; ln -sf libvdpau_r600.so.1.0.0 libvdpau_r600.so.1.0 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_r600.so.1.0.0 )
( cd usr/lib64/vdpau ; ln -sf ../libgallium-25.2.6.so libvdpau_r600.so.1.0.0 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_radeonsi.so )
( cd usr/lib64/vdpau ; ln -sf libvdpau_radeonsi.so.1.0.0 libvdpau_radeonsi.so )
( cd usr/lib64/vdpau ; rm -rf libvdpau_radeonsi.so.1 )
( cd usr/lib64/vdpau ; ln -sf libvdpau_radeonsi.so.1.0.0 libvdpau_radeonsi.so.1 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_radeonsi.so.1.0 )
( cd usr/lib64/vdpau ; ln -sf libvdpau_radeonsi.so.1.0.0 libvdpau_radeonsi.so.1.0 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_radeonsi.so.1.0.0 )
( cd usr/lib64/vdpau ; ln -sf ../libgallium-25.2.6.so libvdpau_radeonsi.so.1.0.0 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_virtio_gpu.so )
( cd usr/lib64/vdpau ; ln -sf libvdpau_virtio_gpu.so.1.0.0 libvdpau_virtio_gpu.so )
( cd usr/lib64/vdpau ; rm -rf libvdpau_virtio_gpu.so.1 )
( cd usr/lib64/vdpau ; ln -sf libvdpau_virtio_gpu.so.1.0.0 libvdpau_virtio_gpu.so.1 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_virtio_gpu.so.1.0 )
( cd usr/lib64/vdpau ; ln -sf libvdpau_virtio_gpu.so.1.0.0 libvdpau_virtio_gpu.so.1.0 )
( cd usr/lib64/vdpau ; rm -rf libvdpau_virtio_gpu.so.1.0.0 )
( cd usr/lib64/vdpau ; ln -sf ../libgallium-25.2.6.so libvdpau_virtio_gpu.so.1.0.0 )
