#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
preserve_perms() {
  NEW="$1"
  OLD="$(dirname ${NEW})/$(basename ${NEW} .new)"
  if [ -e ${OLD} ]; then
    cp -a ${OLD} ${NEW}.incoming
    cat ${NEW} > ${NEW}.incoming
    mv ${NEW}.incoming ${NEW}
  fi
  config ${NEW}
}

config etc/samba/lmhosts.new
preserve_perms etc/rc.d/rc.samba.new

# Commented out 2014-09-15 just in case we do need to change this.
## This won't be needed.  The point here is to preserve the permissions of the existing
## file, if there is one.  I don't see major new development happening in rc.samba...  ;-)
#rm -f etc/rc.d/rc.samba.new

# Since /etc/samba/private/ has moved to /var/lib/samba/private, migrate any
# important files if possible:
if [ -d etc/samba/private -a -d var/lib/samba/private ]; then
  for file in etc/samba/private/* ; do
    if [ -r "$file" -a ! -r "var/lib/samba/private/$(basename $file)" ]; then
      mv "$file" var/lib/samba/private
    fi
  done
  # Might as well try to eliminate this directory, since it should be empty:
  rmdir etc/samba/private 1> /dev/null 2> /dev/null
fi
( cd usr/lib64 ; rm -rf libdcerpc-binding.so )
( cd usr/lib64 ; ln -sf libdcerpc-binding.so.0.0.1 libdcerpc-binding.so )
( cd usr/lib64 ; rm -rf libdcerpc-binding.so.0 )
( cd usr/lib64 ; ln -sf libdcerpc-binding.so.0.0.1 libdcerpc-binding.so.0 )
( cd usr/lib64 ; rm -rf libdcerpc-samr.so )
( cd usr/lib64 ; ln -sf libdcerpc-samr.so.0.0.1 libdcerpc-samr.so )
( cd usr/lib64 ; rm -rf libdcerpc-samr.so.0 )
( cd usr/lib64 ; ln -sf libdcerpc-samr.so.0.0.1 libdcerpc-samr.so.0 )
( cd usr/lib64 ; rm -rf libdcerpc-server-core.so )
( cd usr/lib64 ; ln -sf libdcerpc-server-core.so.0.0.1 libdcerpc-server-core.so )
( cd usr/lib64 ; rm -rf libdcerpc-server-core.so.0 )
( cd usr/lib64 ; ln -sf libdcerpc-server-core.so.0.0.1 libdcerpc-server-core.so.0 )
( cd usr/lib64 ; rm -rf libdcerpc-server.so )
( cd usr/lib64 ; ln -sf libdcerpc-server.so.0.0.1 libdcerpc-server.so )
( cd usr/lib64 ; rm -rf libdcerpc-server.so.0 )
( cd usr/lib64 ; ln -sf libdcerpc-server.so.0.0.1 libdcerpc-server.so.0 )
( cd usr/lib64 ; rm -rf libdcerpc.so )
( cd usr/lib64 ; ln -sf libdcerpc.so.0.0.1 libdcerpc.so )
( cd usr/lib64 ; rm -rf libdcerpc.so.0 )
( cd usr/lib64 ; ln -sf libdcerpc.so.0.0.1 libdcerpc.so.0 )
( cd usr/lib64 ; rm -rf libldb.so )
( cd usr/lib64 ; ln -sf libldb.so.2.11.0 libldb.so )
( cd usr/lib64 ; rm -rf libldb.so.2 )
( cd usr/lib64 ; ln -sf libldb.so.2.11.0 libldb.so.2 )
( cd usr/lib64 ; rm -rf libndr-krb5pac.so )
( cd usr/lib64 ; ln -sf libndr-krb5pac.so.0.0.1 libndr-krb5pac.so )
( cd usr/lib64 ; rm -rf libndr-krb5pac.so.0 )
( cd usr/lib64 ; ln -sf libndr-krb5pac.so.0.0.1 libndr-krb5pac.so.0 )
( cd usr/lib64 ; rm -rf libndr-nbt.so )
( cd usr/lib64 ; ln -sf libndr-nbt.so.0.0.1 libndr-nbt.so )
( cd usr/lib64 ; rm -rf libndr-nbt.so.0 )
( cd usr/lib64 ; ln -sf libndr-nbt.so.0.0.1 libndr-nbt.so.0 )
( cd usr/lib64 ; rm -rf libndr-standard.so )
( cd usr/lib64 ; ln -sf libndr-standard.so.0.0.1 libndr-standard.so )
( cd usr/lib64 ; rm -rf libndr-standard.so.0 )
( cd usr/lib64 ; ln -sf libndr-standard.so.0.0.1 libndr-standard.so.0 )
( cd usr/lib64 ; rm -rf libndr.so )
( cd usr/lib64 ; ln -sf libndr.so.6.0.0 libndr.so )
( cd usr/lib64 ; rm -rf libndr.so.6 )
( cd usr/lib64 ; ln -sf libndr.so.6.0.0 libndr.so.6 )
( cd usr/lib64 ; rm -rf libnetapi.so )
( cd usr/lib64 ; ln -sf libnetapi.so.1.0.0 libnetapi.so )
( cd usr/lib64 ; rm -rf libnetapi.so.1 )
( cd usr/lib64 ; ln -sf libnetapi.so.1.0.0 libnetapi.so.1 )
( cd usr/lib64 ; rm -rf libsamba-credentials.so )
( cd usr/lib64 ; ln -sf libsamba-credentials.so.1.0.0 libsamba-credentials.so )
( cd usr/lib64 ; rm -rf libsamba-credentials.so.1 )
( cd usr/lib64 ; ln -sf libsamba-credentials.so.1.0.0 libsamba-credentials.so.1 )
( cd usr/lib64 ; rm -rf libsamba-errors.so )
( cd usr/lib64 ; ln -sf libsamba-errors.so.1.0.0 libsamba-errors.so )
( cd usr/lib64 ; rm -rf libsamba-errors.so.1 )
( cd usr/lib64 ; ln -sf libsamba-errors.so.1.0.0 libsamba-errors.so.1 )
( cd usr/lib64 ; rm -rf libsamba-hostconfig.so )
( cd usr/lib64 ; ln -sf libsamba-hostconfig.so.0.0.1 libsamba-hostconfig.so )
( cd usr/lib64 ; rm -rf libsamba-hostconfig.so.0 )
( cd usr/lib64 ; ln -sf libsamba-hostconfig.so.0.0.1 libsamba-hostconfig.so.0 )
( cd usr/lib64 ; rm -rf libsamba-passdb.so )
( cd usr/lib64 ; ln -sf libsamba-passdb.so.0.30.0 libsamba-passdb.so )
( cd usr/lib64 ; rm -rf libsamba-passdb.so.0 )
( cd usr/lib64 ; ln -sf libsamba-passdb.so.0.30.0 libsamba-passdb.so.0 )
( cd usr/lib64 ; rm -rf libsamba-policy.so )
( cd usr/lib64 ; ln -sf libsamba-policy.so.0.0.1 libsamba-policy.so )
( cd usr/lib64 ; rm -rf libsamba-policy.so.0 )
( cd usr/lib64 ; ln -sf libsamba-policy.so.0.0.1 libsamba-policy.so.0 )
( cd usr/lib64 ; rm -rf libsamba-util.so )
( cd usr/lib64 ; ln -sf libsamba-util.so.0.0.1 libsamba-util.so )
( cd usr/lib64 ; rm -rf libsamba-util.so.0 )
( cd usr/lib64 ; ln -sf libsamba-util.so.0.0.1 libsamba-util.so.0 )
( cd usr/lib64 ; rm -rf libsamdb.so )
( cd usr/lib64 ; ln -sf libsamdb.so.0.0.1 libsamdb.so )
( cd usr/lib64 ; rm -rf libsamdb.so.0 )
( cd usr/lib64 ; ln -sf libsamdb.so.0.0.1 libsamdb.so.0 )
( cd usr/lib64 ; rm -rf libsmbclient.so )
( cd usr/lib64 ; ln -sf libsmbclient.so.0.8.1 libsmbclient.so )
( cd usr/lib64 ; rm -rf libsmbclient.so.0 )
( cd usr/lib64 ; ln -sf libsmbclient.so.0.8.1 libsmbclient.so.0 )
( cd usr/lib64 ; rm -rf libsmbconf.so )
( cd usr/lib64 ; ln -sf libsmbconf.so.0.0.1 libsmbconf.so )
( cd usr/lib64 ; rm -rf libsmbconf.so.0 )
( cd usr/lib64 ; ln -sf libsmbconf.so.0.0.1 libsmbconf.so.0 )
( cd usr/lib64 ; rm -rf libsmbldap.so )
( cd usr/lib64 ; ln -sf libsmbldap.so.2.1.0 libsmbldap.so )
( cd usr/lib64 ; rm -rf libsmbldap.so.2 )
( cd usr/lib64 ; ln -sf libsmbldap.so.2.1.0 libsmbldap.so.2 )
( cd usr/lib64 ; rm -rf libtevent-util.so )
( cd usr/lib64 ; ln -sf libtevent-util.so.0.0.1 libtevent-util.so )
( cd usr/lib64 ; rm -rf libtevent-util.so.0 )
( cd usr/lib64 ; ln -sf libtevent-util.so.0.0.1 libtevent-util.so.0 )
( cd usr/lib64 ; rm -rf libwbclient.so )
( cd usr/lib64 ; ln -sf libwbclient.so.0.16 libwbclient.so )
( cd usr/lib64 ; rm -rf libwbclient.so.0 )
( cd usr/lib64 ; ln -sf libwbclient.so.0.16 libwbclient.so.0 )
