config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# Keep same perms on rc.bluetooth.new:
if [ -e etc/rc.d/rc.bluetooth ]; then
  cp -a etc/rc.d/rc.bluetooth etc/rc.d/rc.bluetooth.new.incoming
  cat etc/rc.d/rc.bluetooth.new > etc/rc.d/rc.bluetooth.new.incoming
  mv etc/rc.d/rc.bluetooth.new.incoming etc/rc.d/rc.bluetooth.new
fi

config etc/rc.d/rc.bluetooth.new
config etc/bluetooth/input.conf.new
config etc/bluetooth/main.conf.new
config etc/bluetooth/network.conf.new
config etc/default/bluetooth.new

( cd usr/lib64 ; rm -rf libbluetooth.so )
( cd usr/lib64 ; ln -sf libbluetooth.so.3.19.15 libbluetooth.so )
( cd usr/lib64 ; rm -rf libbluetooth.so.3 )
( cd usr/lib64 ; ln -sf libbluetooth.so.3.19.15 libbluetooth.so.3 )
( cd usr/sbin ; rm -rf bluetoothd )
( cd usr/sbin ; ln -sf ../libexec/bluetooth/bluetoothd bluetoothd )
