#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# Process all .new config files:
for file in etc/ImageMagick*/*.new ; do
  config $file
done
( cd usr/bin ; rm -rf animate )
( cd usr/bin ; ln -sf magick animate )
( cd usr/bin ; rm -rf compare )
( cd usr/bin ; ln -sf magick compare )
( cd usr/bin ; rm -rf composite )
( cd usr/bin ; ln -sf magick composite )
( cd usr/bin ; rm -rf conjure )
( cd usr/bin ; ln -sf magick conjure )
( cd usr/bin ; rm -rf convert )
( cd usr/bin ; ln -sf magick convert )
( cd usr/bin ; rm -rf display )
( cd usr/bin ; ln -sf magick display )
( cd usr/bin ; rm -rf identify )
( cd usr/bin ; ln -sf magick identify )
( cd usr/bin ; rm -rf import )
( cd usr/bin ; ln -sf magick import )
( cd usr/bin ; rm -rf magick-script )
( cd usr/bin ; ln -sf magick magick-script )
( cd usr/bin ; rm -rf mogrify )
( cd usr/bin ; ln -sf magick mogrify )
( cd usr/bin ; rm -rf montage )
( cd usr/bin ; ln -sf magick montage )
( cd usr/bin ; rm -rf stream )
( cd usr/bin ; ln -sf magick stream )
( cd usr/lib64 ; rm -rf libMagick++-7.Q16HDRI.so )
( cd usr/lib64 ; ln -sf libMagick++-7.Q16HDRI.so.5.0.0 libMagick++-7.Q16HDRI.so )
( cd usr/lib64 ; rm -rf libMagick++-7.Q16HDRI.so.5 )
( cd usr/lib64 ; ln -sf libMagick++-7.Q16HDRI.so.5.0.0 libMagick++-7.Q16HDRI.so.5 )
( cd usr/lib64 ; rm -rf libMagickCore-7.Q16HDRI.so )
( cd usr/lib64 ; ln -sf libMagickCore-7.Q16HDRI.so.10.0.2 libMagickCore-7.Q16HDRI.so )
( cd usr/lib64 ; rm -rf libMagickCore-7.Q16HDRI.so.10 )
( cd usr/lib64 ; ln -sf libMagickCore-7.Q16HDRI.so.10.0.2 libMagickCore-7.Q16HDRI.so.10 )
( cd usr/lib64 ; rm -rf libMagickWand-7.Q16HDRI.so )
( cd usr/lib64 ; ln -sf libMagickWand-7.Q16HDRI.so.10.0.2 libMagickWand-7.Q16HDRI.so )
( cd usr/lib64 ; rm -rf libMagickWand-7.Q16HDRI.so.10 )
( cd usr/lib64 ; ln -sf libMagickWand-7.Q16HDRI.so.10.0.2 libMagickWand-7.Q16HDRI.so.10 )
