# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [14.0.2] – 2025-10-19

### Changed

- Quartz plugin code paths to support older macOS and iOS versions have been
  restored. Their removal was a regression in Graphviz 13.0.0.
- In the CMake build system, whether Quartz-dependent components are built or
  not can now be controlled by the `-DWITH_QUARTZ={AUTO|ON|OFF}` option.
- `dot_builtins`, when compiled with the CMake build system, now supports the
  Quartz plugin if it is enabled at build time.

### Fixed

- Memory corruption when using the Java bindings to render to a string has been
  corrected. This was a regression in Graphviz 2.49.0.
- A minor typo in the `gvpr(3)` man page has been fixed.
- Calling `gvpr(…, NULL)` no longer causes null pointer dereferences.

## [14.0.1] – 2025-10-05

### Changed

- The pre-built macOS package for Autotools is now a .pkg file instead of a
  tarball of binaries. #2726, !4348
- In the CMake build system, whether Ghostscript-dependent components are built
  or not can now be controlled by the `-DWITH_GHOSTSCRIPT={AUTO|ON|OFF}` option.
  #2735

### Fixed

- Points generated as curves by the dot layout algorithm are once again placed
  correctly. This was a regression in Graphviz 14.0.0. #2734

## [14.0.0] – 2025-09-21

### Changed

- In the CMake build system, whether GTK-dependent components are built or not
  can now be controlled by the `-DWITH_GTK={AUTO|ON|OFF}` option. #2714
- The CMake build system now includes man pages for the `circo`, `dot2gxl`,
  `fdp`, `gv2gml`, `gv2gxl`, `gvmap.sh`, `gxl2dot`, `neato`, `sfdp`, and `twopi`
  aliases. #1753, #2530
- In the CMake build system, whether Poppler-dependent components are built or
  not can now be controlled by the `-DWITH_POPPLER={AUTO|ON|OFF}` option. #2714
- The gvpr `-a` option is no longer limited to 100 arguments. It is limited now
  only by available memory.
- In the CMake build system, whether librsvg-dependent components are built or
  not can now be controlled by the `-DWITH_RSVG={AUTO|ON|OFF}` option. #2714
- In the CMake build system, whether libwebp-dependent components are built or
  not can now be controlled by the `-DWITH_WEBP={AUTO|ON|OFF}` option. #2714
- **Breaking**: The `CDT_VERSION` macro has been updated to reflect the last
  time an API-breaking change was made. This should have happened in Graphviz
  9.0.0 and then multiple other releases since then. #2722
- In the CMake build system, whether X11-dependent components are built or not
  can now be controlled by the `-DWITH_X={AUTO|ON|OFF}` option. #2714
- The graphviz_version.h header includes macros `GRAPHVIZ_VERSION_MAJOR`,
  `GRAPHVIZ_VERSION_MINOR`, `GRAPHVIZ_VERSION_PATCH` for compile-time
  discrimination based on the Graphviz version. #2716
- The CMake build system no longer allows overriding the Graphviz version with
  `-DVERSION=…`.
- **Breaking**: The `agcanonStr` function has been removed.

### Fixed

- The CMake build system no longer installs an `sfdp` alias when SFDP is
  disabled (`-Dwith_sfdp=OFF`).
- The plugin version in pre-built Fedora and Rocky Linux packages has been
  corrected 6 → 8. This change should have happened in Graphviz 13.0.0.
- Empty HTML-like labels (`<>`) are once again processed successfully. This was
  a regression in Graphviz 13.0.0. #2727
- Some typos in the cgraph man page have been fixed.

## [13.1.2] – 2025-08-09

### Changed

- `DFLT_GVPRPATH`, a `$PATH`-like variable that gvpr uses to locate
  user-referenced files, is now computed at runtime instead of build time. This
  removes a barrier to relocating a Graphviz installation from one directory to
  another.
- In the CMake build system, whether GDK-dependent components are built or not
  can now be controlled by the `-DWITH_GDK={AUTO|ON|OFF}` option. #2714

### Fixed

- Gvedit and Smyrna on MinGW can now correctly locate their supporting runtime
  data directories.
- The gvpr options `-v` for printing verbose messages is documented. This has
  been supported since Graphviz 2.30 but undocumented.
- When using the CMake build system, `DFLT_GVPRPATH` is no longer incorrectly
  missing a ".:" prefix.
- On macOS, processing graphs involving URLs with the Quartz plugin is once
  again possible. Previously this would crash. This was a regression in Graphviz
  13.0.1. #2712
- In gvpr, updating a map or deleting items from the map no longer triggers a
  use-after-free. #2707

## [13.1.1] – 2025-07-20

### Changed

- When built with PangoCairo, the Kitty plugin is now available in Graphviz
  static builds. Previously it was only available in shared library (on-demand
  plugin loading) builds.
- The distributed Fedora and Rocky Linux packages now include the Kitty plugin.
  #2704
- On Windows, the GDI+ plugin is now available in Graphviz static builds.
  Previously it was only available in shared library (on-demand plugin loading)
  builds.
- Processing a graph with GVPR no longer makes explicit the default `"\N"` label
  for nodes. This undoes a change from Graphviz 13.0.1. #2705
- `nop` no longer preserves empty string labels. This undoes a change from
  Graphviz 13.0.1. #2436, #2705
- The order of programmatic calls to `gvContext`/`gvContextPlugin` and
  `agmemread` once again affects default node labels. This undoes a change from
  Graphviz 13.0.1. #2434, #2705

### Fixed

- Spline routing can now deal with horizontal and vertical lines. This removes
  some instances of the “Something is probably seriously wrong” warning. #241
- Using `layerselect` beyond layer 1 no longer causes crashes. #1648
- Correct parsing of a PDF file’s `/MediaBox` section no longer depends on the
  internal `BUFSIZ` constant.
- Round tripping a graph through a file no longer causes it to acquire a default
  node label `\N`. #2705

## [13.1.0] – 2025-07-01

### Added

- A new command line option, `-Afoo=bar`, serves as a shorthand way of writing
  `-Gfoo=bar -Nfoo=bar -Efoo=bar`. #2278

### Fixed

- Inter-cluster edges are no longer spuriously duplicated. #162, #258, #2615
- When using the CMake build system, configuration no longer fails with syntax
  errors when PangoCairo is unavailable. This was a regression in Graphviz
  13.0.0. #2697

## [13.0.1] – 2025-06-15

### Changed

- When using the CMake build system, the minimum required version of CMake has
  been upgraded 3.14.1 → 3.21.
- Building Graphviz from source now requires a C compiler with ISO C17 support.
- Processing a graph with GVPR now makes explicit the default `"\N"` label for
  nodes.

### Fixed

- Graphs with large weights no longer trigger double `free`s. #1494, #2331
- `nop` preserves empty string labels. #2436
- The order of programmatic calls to `gvContext`/`gvContextPlugin` and
  `agmemread` no longer affects default node labels. #2434
- Adjacency matrices are sparse and expanded on demand, removing out-of-bounds
  accesses when computing these for some graphs. #1472

## [13.0.0] – 2025-06-08

### Added

- Support for building the SWIG-generated Ruby language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-DENABLE_RUBY={AUTO|ON|OFF}` option.
- A new plugin for outputting ASCII art has been implemented, `-Tascii`. This
  relies on [AA-lib](https://aa-project.sourceforge.net/aalib/) and is only
  supported in the CMake build system. #2421
- In gvpr, a new function `rename()` has been added for nodes. See `man gvpr`
  for more information.

### Changed

- If Quartz is enabled on macOS, the autotools build will include support for it
  as a built-in plugin for static builds, for dependency free i.e. PDF support.
- Improved `agwrite` so it is much faster (linear not quadratic) when there are
  many small subgraphs. #2593
- **Breaking**: `rank_t.cache_nc` is now a `int64_t`.
- **Breaking**: The `agreadline` function has been removed. #2558
- **Breaking**: `gvRenderData` takes its `length` parameter as a `size_t *`. The
  `GVJ_t` fields `output_data_allocated` and `output_data_position` have type
  `size_t`.
- The `GRAPHVIZ_CLI` variable in the CMake build system now additionally
  controls whether the utilities `diffimg` and `prune` are built.
- **Breaking**: The cgraph macros `agnew` and `agnnew` have been removed.
- **Breaking**: The cgraph functions `agalloc`, `agrealloc`, and `agfree` have
  been removed.
- **Breaking**: The cdt queue types, `DT_QUEUE`, `Dtqueue`, `_Dtqueue` have been
  removed.
- **Breaking**: The cdt aliases `struct _dthold_s`, `struct _dtdata_s`,
  `struct _dtmethod_s`, `struct _dtstat_s` have been removed.
- **Breaking**: The cdt type `_Dttree` has been removed.
- **Breaking**: The cdt aliases `struct _dtlink_s`, `struct _dtdisc_s`, and
  `struct _dt_s` have been renamed to `struct dtlink_s_`, `struct dtdisc_s_`,
  and `struct dt_s_` respectively.
- **Breaking**: The cdt macro `DT_PRIME` has been removed.
- **Breaking**: The cdt field `Dt_t.data` is now a `Dtdata_t` instead of
  `Dtdata_t *`.
- **Breaking**: `GVJ_t.imagedata` is now an `unsigned char *`.
- The sandboxer implemented in Graphviz 12.2.1, `dot_sandbox`, supports macOS.
- The baseline version of Autoconf required to build Graphviz from source has
  been upgraded 2.61 → 2.69.
- Building Graphviz from source now requires a C compiler with ISO C11 support.
- GVPR programs are now able to print `char` and `unsigned` variables. #2587
- CMake projects using Graphviz as a subproject (`add_subdirectory`) can now
  link against and use `cgraph`, `pathplan`, and `xdot`.
- CMake projects using Graphviz as an installed third-party dependency can now
  discover its libraries with `find_package(graphviz)` and then use them as e.g.
  `target_link_libraries(myapp PRIVATE graphviz::cgraph)`. #2598
- Verbose `checkpath` warnings about ports not lying in their expected boxes
  have been removed.
- In verbose mode (`-v`) the dot layout algorithm now notes when it is entering
  each layout phase. #2540
- **Breaking**: The `EXPANDBP` macro has been removed.
- **Breaking**: The `EXPANDBB` macro has been removed.
- **Breaking**: `Agclos_t.strdict` is now an opaque pointer.
- **Breaking**: `agstrfree` takes an extra parameter indicating whether the
  string being freed is an HTML-like string.
- **Breaking**: The `agcanon` function has been removed.
- **Breaking**: The `Agiddisc_t.alloc` member has been removed.
- **Breaking**: The `cflag` parameter to `agidsubg` has been removed.
- The CMake build system now installs libgvpr.
- The CMake build system now sets `DFLT_GVPRPATH` when compiling libgvpr.
- The CMake build system now installs the included library of gvpr programs.
- **Breaking**: The `all` parameter to `exclose` has been removed.
- MinGW on 32-bit x86 (“mingw32”) is no longer supported as a platform.
  Installers and release archives for this platform are no longer provided.
  #2649
- `gvgen` supports a new option, `-u<seed>`, for specifying the initial state of
  the random number generator (RNG). The way in which the RNG is seeded has
  slightly changed.
- **Breaking**: libcgraph’s SO name has been updated 6 → 7.
- The core plugin’s SVG output (`-Tsvg`, `-Tsvg_inline`) now sets
  `xml:space="preserve"` on text elements for more accurate display.
- **Breaking**: To duplicate strings, you now should distinguish between regular
  text strings and HTML-like strings. Regular text strings are handled through
  `agstrdup_text` and HTML-like strings are handled through `agstrdup_html`. The
  The `agstrdup` function has been retained for backwards compatibility, but
  should be avoided where possible due to its ambiguity with respect to the
  caller’s intent. Similarly for string binding, `agstrbind` has gained two
  variants `agstrbind_text` and `agstrbind_html`. These should be used in
  preference to `agstrbind` whenever possible. Similarly for attribute
  creation/lookup, `agattr` has gained two variants `agattr_text` and
  `agattr_html`. These should be used in preference to `agattr` whenever
  possible. Similarly for safe attribute creation/lookup, `agsafeset` has gained
  two variants `agsafeset_text` and `agsafeset_html`. These should be used in
  preference to `agsafeset` whenever possible. Similarly, `agxset` has gained
  two variants `agxset_text` and `agxset_html`. These should be used in
  preference to `agxset` whenever possible. Similarly, `agset` has gained two
  variants `agset_text` and `agset_html`. These should be used in preference to
  `agset` whenever possible. #2089, #2641
- **Breaking**: The `EDGEOF` macro has been removed.
- The Autotools build system enables large file support on 32-bit platforms.
- **Breaking**: The Graphviz plugin version has been updated 6 → 8. A side
  effect of this is the config6 file becoming config8.
- The core plugin’s SVG output (`-Tsvg`, `-Tsvg_inline`) uses a `viewBox` that
  matches the image’s dimensions. This reverts behavior introduced in Graphviz
  2.38.0 to the behavior Graphviz 2.36.0 and prior had. The difference is most
  apparent when using a non-default `dpi` setting. #2669
- The Tcl bindings have been updated for compatibility with Tcl 9. #2668
- The SVG output format (`-Tsvg`, `-Tsvg_inline`) no longer duplicates font
  families.
- **Breaking**: The function `aginternalmapclearlocalnames` has been removed.
  #2664
- In gvpr programs, the `#` and `in` operators now work on `ARGV`. #2582
- **Breaking**: `xdot_color_stop.frac` is now a `double`.
- The GD plugin’s PNG output (`-Tpng:cairo:gd`) now sets DPI in the written PNG.
  #1617
- The GDI+ plugin’s output (`-T*:cairo:gdiplus`) now sets DPI in the written
  output. #1617
- The Quartz plugin’s PNG output (`-Tpng:cairo:quartz`) now sets DPI in the
  written PNG. #1617
- **Breaking**: The `agconcat` function now takes an extra `filename` parameter.
  If you are updating calling code, passing `NULL` for this parameter is a
  reasonable migration strategy.
- **Breaking**: The `agsetfile` function has been removed.
- The GDK plugin’s output (`-T*:cairo:gdk`) now sets DPI in written JPEGs and
  PNGs. #1617
- **Breaking**: The `Agsym_t` struct has gained a new member, `owner`.

### Fixed

- Numeric overflows when computing the total crossings in a graph with a large
  number of crossings have been avoided. #2621
- A `free` of an invalid pointer has been fixed in the GD plugin. This was a
  regression in Graphviz 12.1.1.
- A double-`free` when using rotated images was fixed in the GD plugin. This was
  a regression in Graphviz 2.26.0.
- Guile 2.2 discovery has been restored in the Autotools build system. This was
  a regression in Graphviz 12.2.0. #2624
- Legacy information about memory disciplines has been removed from the cgraph
  man page.
- Some information in the gvc.3 man page that contradicted the gvc.h public
  header has been corrected.
- Smyrna is once again compilable on macOS. This was a regression in Graphviz
  10.0.1. #2631
- non-HTML (regular) strings and HTML-like strings are no longer considered
  equivalent internally. This allows you to have a non-HTML string and an
  HTML-like string with the same textual content. #2089
- Smyrna no longer crashes when selecting `Edit→Attributes` with no open graph.
  #2635
- A bug in point map handling, where comparison of integer points were accessed
  as doubles, has been corrected. The user facing consequences of this is
  unknown, but could potentially lead to crashes, at least on 32-bit platforms.
  Point maps are used by the neato layout engine. This was a regression in
  Graphviz 12.0.0.
- The executables in the Windows 64-bit Debug release artifacts were statically
  linked, not dynamically linked like the 64-bit Release and all the 32-bit
  executables. This has now been corrected. This was a regression in Graphviz
  12.0.0. #2630
- The `viewBox` attribute of an included SVG image no longer overrides the
  `height` and `width` attributes, even when it precedes them. This was a
  regression in Graphviz 2.30. #2636
- The interpretation of `viewBox` attributes in included SVG images has been
  corrected. #2636
- Parsing of JPEG images used as node shapes has been corrected. This fixes a
  problem where no or incorrectly sized images appeared in the output. Please
  note that a bug in the GD plugin, which causes Graphviz to crash in Windows
  Debug builds, now unfortunately seems to always occur when using the GD
  plugin and JPEG images as node shapes. See
  https://graphviz.org/docs/outputs/#image-formats for details. #2619
- `twopi` no longer crashes when processing graphs with `splines="ortho"`. #2643
- Network simplex functions have been refactored to avoid recursion. Now graphs
  with deep node chains that previously caused stack overflows can be processed.
  #2646
- Calling the GVPR function `lock` with a second argument `> 2³¹ - 1` is no
  longer misinterpreted as a negative number.
- Out-of-bounds accesses during `gvgen` random tree generation have been fixed.
  #2640
- `gvmap` no longer reads out-of-bounds memory when processing the
  `-c_opacity=…` command line option. This was a regression in Graphviz 2.49.0.
- Using `rankdir=LR` in combination with `ltail` no longer causes crashes in
  edge cases. #1949
- Using `splines=curved` no longer causes crashes when cut points unexpectedly
  do not intersect bounding boxes. #1453
- In the CMake build system, the configuration step during installation
  (`dot -c`) now anticipates that `$LD_LIBRARY_PATH` and `$DYLD_LIBRARY_PATH`
  may be non-empty. #2676
- Failures during installing nodes into ranks now results in a graceful exit
  rather than referencing invalid memory. #1581
- When using the Tcl bindings, deleting a graph no longer triggers a
  use-after-free. This was a regression in Graphviz 2.30. #2618
- The `layout` command in the Tcl bindings works once again. This was a
  regression in Graphviz 2.42.0. #2618
- In the CMake build system, configuring with
  `-DENABLE_PYTHON=ON -DENABLE_SWIG=ON` no longer spuriously fails. #2675
- An assertion failure when processing graphs with empty ranks has been fixed.
  #1514
- Using GVPR to set a default attribute on a subgraph whose root graph has no
  default for that attribute no longer incorrectly sets the default on the root
  graph. #2639
- Mingle no longer crashes when doing Y coordinate search. This was a regression
  in Graphviz 2.47.0. #2599
- Smyrna no longer frees invalid pointers when processing xdot input. This was a
  regression in Graphviz 2.50.0. #2687
- Smyrna no longer crashes when processing xdot gradient colors or font
  characters. This was a regression in Graphviz 2.34.0.

## [12.2.1] – 2024-12-07

### Added

- Support for building the SWIG-generated R language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-DENABLE_R={AUTO|ON|OFF}` option.
- A sandboxing wrapper, `dot_sandbox`, is now included with Graphviz. Users
  should prefer their platform’s native security solutions, but if nothing
  better is available this wrapper offers safe processing of untrusted inputs in
  some scenarios.

### Changed

- JPEG images without an `APP0` leading segment are supported for use in `src`
  fields and friends. Previously Graphviz was overly strict with the types of
  JPEGs it would recognize. #2619
- The CMake build system now discovers and uses `pango_fc_font_lock_face` if
  possible, for the Pango plugin to provide more information about used fonts.

### Fixed

- The GVPR library program `depath` no longer acts on previously deleted nodes,
  causing unpredictable results. #1702
- Void-typed function parameters (`int foo(void bar)`) and variables `void baz;`
  in GVPR are gracefully rejected. #2585
- Input that induce a set node height but no set node width no longer crash with
  the failure “Assertion failed: `(r->boundary[i] <= r->boundary[NUMDIMS + i])`,
  function RTreeInsert”. It is typically not obvious to users when their input
  falls into this situation, hence why the assertion message is quoted here.
  This was a regression in Graphviz 12.0.0. #2613
- Strings containing double quote characters preceded by escape sequences (e.g.
  `\n"`) are once again correctly escaped in dot or canonical output. This was a
  regression in Graphviz 9.0.0. #2614
- `dot_builtins` no longer lists duplicate format options in its error messages.
  #2604
- A precision error that resulted in truncated edge lines has been corrected.
  This was a regression in Graphviz 12.0.0. #2620
- The xlib plugin (`-Tx11`) resets its initialization state during finalization.
  This fixes a rare scenario where multiple input graphs are supplied and
  initialization for one of the not-first graphs fails. In this scenario,
  finalization would be unaware of this failure and act on invalid state.

## [12.2.0] – 2024-11-04

### Removed

- Visual Studio build files have been removed. CMake is now the only supported
  build system on Windows.

### Added

- Support for building the SWIG-generated PHP language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-DENABLE_PHP={AUTO|ON|OFF}` option.
- Support for building the SWIG-generated Python language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-DENABLE_PYTHON={AUTO|ON|OFF}` option.

### Changed

- An algorithm closer to that described in RFC 1942 and/or the CSS 2.1
  specification is now used for sizing table cells within HTML-like labels. This
  is less scalable than the network simplex algorithm it replaces, but in
  general produces more intuitive results. #2159
- Tooltips on table elements within HTML-like labels are now propagated to SVGs
  produced by the core plugin (`-Tsvg`) even when the elements do not have
  `href` attributes. #1425
- In the Autotools build system, `pkg-config` is the only supported way for
  discovering Guile. Previous use of `guile-config*` has been removed. #2606
- The Autotools release artifacts for macOS (`Darwin_*_graphviz-*.tar.gz`) now
  use relative paths in links to dependent libraries and plugins. This should
  make the tree relocatable instead of having to live at /Users/gitlab/builds.
  #2501
- `gml2gv` no longer maps GML `label` attributes to Graphviz `name` attributes.
  These are now mapped to Graphviz `label` attributes. #2586

### Fixed

- In the Autotools build system, the core plugin links against libm, fixing some
  unresolvable symbols. This was a regression in Graphviz 4.0.0. Though it would
  primarily have affected non-Graphviz applications attempting to load this
  plugin on Linux.
- The osage layout engine now understands a cluster to be indicated by the
  common rules, including the “cluster” prefix being case insensitive and the
  `cluster=true` attribute as an alternative. #2187
- `acyclic` once again produces its output on stdout. This was a regression in
  Graphviz 10.0.1. #2600
- When using the Tclpathplan module, created vgpanes can once again be named and
  addressed. This was a regression in Graphviz 12.1.2.
- Omitting a polygon identifier when running triangulation using the Tclpathplan
  module (e.g. `vgpane0 triangulate` instead of `vgpane0 triangulate 42`) no
  longer goes unnoticed and reads invalid memory. This bug seems to have existed
  since the first revision of Graphviz.
- When using the Tclpathplan module, defining a malformed &lt;3-point polygon
  and then attempting to triangulate this polygon no longer reads invalid
  memory. This case is now rejected with an error during triangulation. Like the
  previous entry, this bug seems to have existed since the first revision of
  Graphviz.
- When using the Tclpathplan module, binding a pane’s triangulation callback to
  a string ending in a trailing `%` (e.g. `vgpane0 bind triangle %`) no longer
  causes later out-of-bounds reads during triangulation. Like the previous
  entries, this bug seems to have existed since the first revision of Graphviz.
  #2596
- Mouse right-clicks in Smyrna are no longer sticky. In some contexts,
  right-clicking the mouse would register a mouse down event but no mouse up
  event, leading Smyrna to believe the user was dragging with the right button
  held down.
- Arrowhead missing from tail-end of edge #2437
- The Ruby bindings package (libgv-ruby) is once again installable on Ubuntu.
  This became uninstallable when Ruby 1.8 was no longer available on Ubuntu, as
  it had a hard coded dependency of Ruby 1.8. This has now been relaxed to
  depend on any Ruby version ≥ 1.8. #2607
- Generated GIFs and JPEGs display the graphed image instead of a single solid
  color. This was a regression in Graphviz 12.1.1. #2609
- The CMake build system includes some supporting pieces of the SWIG-generated
  language bindings that were previously missing. It also links further
  dependencies that were previously missing.
- In the CMake build system, linking of the Guile language bindings uses the
  full path to libguile, fixing issues on macOS.
- The provided release packages for Debian-based operating systems (only Ubuntu
  currently) have corrected package dependencies. #2466
- Discussion of `gvpr -c ""` in the `gvpr` man page has been removed. This
  invocation did not do what was claimed. #2584

## [12.1.2] – 2024-09-28

### Changed

- In the Autotools build system, the rsvg plugin is no longer built when
  pangocairo is missing. Previously, when librsvg was found but pangocairo was
  not, this plugin would be enabled and built but offer no functionality.
- The RSVG plugin now requires librsvg ≥ 2.42.7.
- The RSVG plugin uses newer librsvg APIs where available. #2206

### Fixed

- In the Autotools build system, fallback discovery of libANN when `pkg-config`
  support is unavailable has been corrected to properly enable use of libANN.
  This primarily affects `mingle` users on Debian-based operating systems or
  macOS.
- The RSVG plugin no longer dereferences a null pointer when failing to create
  new RSVG handles.
- The Pango plugin no longer assumes a little endian environment when loading PS
  images.
- Deleting a “vgpane” when using the Tclpathplan module no longer frees an
  invalid pointer. This bug appears to have existed since the first revision of
  Graphviz. That is, deleting a “vgpane” has always crashed the TCL interpreter
  or silently corrupted the heap prior to this release.

## [12.1.1] – 2024-09-09

### Added

- Support for building the SWIG-generated Guile language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-DENABLE_GUILE={AUTO|ON|OFF}` option.
- Support for building the SWIG-generated Java language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-DENABLE_JAVA={AUTO|ON|OFF}` option.
- Support for building the SWIG-generated Lua language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-DENABLE_LUA={AUTO|ON|OFF}` option.
- Support for building the SWIG-generated Perl language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-DENABLE_PERL={AUTO|ON|OFF}` option.

### Changed

- Comparison against a plugin’s `knowncolors` array is now case-insensitive,
  rather than requiring all entries of the array to be lower-cased. The
  requirement that the `knowncolors` array is lexically ordered remains.
- The Smyrna “Color Theme”, “Edge Attr. For Color”, and “Node Alpha” settings
  have been removed. The values of these settings had no effect.
- Graphviz libraries set close-on-exec on job output files being written and
  user shape files being read. This should only affect applications using
  Graphviz libraries that rely on a fork-and-exec-ed child subprocess being able
  to access these open files. Applications with this requirement can regain the
  old behavior by unsetting the close-on-exec flag immediately after creating
  these objects. Graphviz libraries themselves are not affected by whether or
  not this flag is set.
- The Autotools build system no longer detects or uses the `-perl` option to
  SWIG to build Perl language bindings. Only `-perl5` is used.

### Fixed

- A reference to the non-existent `colxlate` function in an error message has
  been corrected to `colorxlate`.
- `gvgen` no longer crashes sometimes when running random graph generation. This
  was a regression in Graphviz 12.0.0. #2588
- Dashed and dotted pen styles in VRML images loaded by the GD plugin have been
  corrected.
- `mm2gv` no longer crashes when reading various types of malformed Matrix
  Market files.
- The `edgepaint` `--color_scheme` command-line option is once again functional.
  This was a regression in Graphviz 2.49.0. #2591
- An incorrect deallocation call during OpenGL texture construction failure has
  been corrected. This could previously have caused crashes or heap corruption.
  This was a regression in Graphviz 2.26.0.
- The CMake build on Windows no longer fails if TCL is detected. This was
  technically a regression in 12.0.0 since building the Graphviz TCL bindings
  was integrated into the CMake build system in that release. #2581
- When its output file cannot be opened, `edgepaint` no longer dereferences a
  null pointer when printing its error message.

## [12.1.0] – 2024-08-12

### Added

- Enable the GNU Triangulated Surface Library (GTS) in Windows builds. #2557
- `dot_builtins` now also includes the vt plugin (`-Tvt` output format).
- The vt plugin gained new output formats, `-Tvt-4up`, `-Tvt-6up`, and
  `-Tvt-8up`, for drawing monochrome 4-, 6-, and 8-pixel-per-character
  visualizations, respectively.
- The CMake build system now includes the WebP plugin also on Windows.
- A Windows x64 `mingle` binary is now built with CMake.
- Support for building the SWIG-generated D language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-DENABLE_D={AUTO|ON|OFF}` option.
- Support for building the SWIG-generated Go language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-DENABLE_GO={AUTO|ON|OFF}` option. The target integer size can be set with
  `-DINTGOSIZE=…` if it is not auto-detected correctly.
- Support for building the SWIG-generated JavaScript language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-DENABLE_JAVASCRIPT={AUTO|ON|OFF}` option.

### Changed

- The GTK plugin, for which build system support was removed in Graphviz 10.0.1,
  has been removed from the portable source tarball. #1848
- To build from source, the required C++ standard has been upgraded from C++11
  to C++17. #2536
- **Breaking**: the CMake variables `enable_ltdl`, `with_expat`, `with_gvedit`,
  `with_smyrna`, `with_zlib`, `enable_tcl`, `enable_swig` and `enable_sharp`
  have been renamed  to `ENABLE_LTDL`, `WITH_EXPAT`, `WITH_GVEDIT`,
  `WITH_SMYRNA`, `WITH_ZLIB`, `ENABLE_TCL`, `ENABLE_SWIG` and `ENABLE_SHARP`,
  respectively.
- To build from source, the required Python version has been upgraded from 3.6
  to 3.8. #2549
- Build system discovery of GDK now looks for GDK 3.0 instead of GDK 2.0. #1848
- Visual Studio build files are no longer distributed in the portable source
  tarball. Builds on Windows must now use a repository clone.

### Fixed

- `ccomps`, `gc`, the fdp layout engine, the neato layout engine, and the
  patchwork algorithm now understand a cluster to be indicated by the common
  rules, including the “cluster” prefix being case insensitive and the
  `cluster=true` attribute as an alternative. #2187
- `overlap` values whose prefixes are themselves valid values (e.g.
  `overlap=scalexy` where `overlap=scale` is also a valid setting) are once
  again usable. Previously such values would silently select the shortest valid
  prefix. This was a regression in Graphviz 2.24.0. #2563
- Setting `overlap=ortho_xy` no longer also runs the constraint pass of
  `overlap=porthoxy`. Setting `overlap=ortho` no longer also runs the constraint
  passes of `overlap=ortho_xy` and `ortho=porthoxy`. This bug has existed ever
  since these overlap modes were introduced in Graphviz 2.4. However its effect
  was masked by the bug discussed in the prior CHANGELOG entry that made it not
  possible to select `overlap=ortho_xy` or `overlap=porthoxy`.
- `splines = true` merging multiedges together when using the neato engine.
  #2241 (fixed on Windows by enabling GTS)
- The GVC output writing APIs handle writes of compressed data `> UINT_MAX` more
  correctly.
- GVPR casts of strings to floats now produce the expected values. This was a
  regression in Graphviz 2.30.
- CMake builds do not support format png:gd #1786
- The diffimg utility is not built in CMake builds #1788 (fixed also for
  Windows x64 builds)
- The Windows x86 `mingle` binary built with CMake no longer fails to start
  because of missing `ANN.dll`.
- The node and edge tags printed by the TK output format (`-Ttk`) are once again
  usable for later referencing those same nodes and edges in TCL scripting. This
  was likely broken in the transition from 32-bit to 64-bit hardware. #2568
- Ubuntu 24.04 binaries incorrectly are ASan enabled and produce memory leak
  errors. #2574
- gvpr’s ability to handle empty string parameters to `printf` (e.g.
  `printf("hello%s world", "")`) has been restored. This was a regression in
  Graphviz 9.0.0. #2577
- pkgIndex.tcl for the TCL bindings is constructed based on target system
  properties instead of host system properties. Previously, cross-compilation
  would result in potentially incorrect library loading directives in this file.
- The Autotools build system no longer checks for the presence of php.h, which
  previously caused spurious failures when trying to build the PHP bindings with
  PHP 8.3. #2589
- A `gvmap` crash due to out-of-bounds memory writes has been fixed. This was a
  regression in Graphviz 8.0.1.

## [12.0.0] – 2024-07-04

### Added

- Support for building the Graphviz TCL bindings has been integrated into the
  CMake build system. This is controllable by the `-Denable_tcl={AUTO|ON|OFF}`
  option.
- Support for building the SWIG-generated TCL language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-Denable_swig={AUTO|ON|OFF}` option.
- Support for building the SWIG-generated C# language bindings has been
  integrated into the CMake build system. This is controllable by the
  `-Denable_sharp={AUTO|ON|OFF}` option.

### Changed

- The Catch2-based test suite in the CMake build system has been ported from
  Catch2 v2 to Catch2 v3. Support for Catch2 v2 has been removed. #2465
- The Windows release artifacts are now built on Windows 2022 and Visual Studio
  2022 17 and toolset v143.
- The macOS release artifacts are now built on macOS 13 (Ventura).
- The CMake build system no longer links `dot_builtins` against libsocket.
- The CMake build system now only compiles `dot_builtins` if building shared
  libraries (`-DBUILD_SHARED_LIBS=ON`).
- **Breaking**: the `polygon_t.style` member is now a struct.
- **Breaking**: the `LEN` and `MAXDOUBLE` constants have been removed.
- Accuracy in processing compass points has been improved.
- **Breaking**: the `CMYK_BYTE` member of the `color_type_t` enum and the
  corresponding `gvolor_t.u.cmyk` field have been removed. The color format this
  mapped to was neither documented nor implemented correctly.
- The Windows releases available for download on graphviz.org now only include
  CMake-produced packages, not MS Build-produced packages. The MS Build packages
  are available in the
  [Gitlab package registry](https://gitlab.com/graphviz/graphviz/-/packages) if
  needed.
- The CMake build system more pervasively sets rpaths of compiled binaries,
  libraries, and plugins, which should result in them more reliably finding
  their supporting components.
  without `$LD_LIBRARY_PATH`/`$DYLD_LIBRARY_PATH` tricks.
- **Breaking**: the `Agraph_t.n_id` field is now an opaque pointer.
- **Breaking**: the libpack functions `putGraphs`, `putRects`, and `shiftGraphs`
  now operate on floating-point points (`pointf`) instead of integer points
  (`point`).
- **Breaking**: the `BF2B` macro has been removed.
- **Breaking**: the undocumented `-Tmp` output format has been removed.
- **Breaking**: the arith.h header defines neither `_GNU_SOURCE` nor `sincos`
  any more. None of the build systems attempt to discover `sincos` any more.
- The FIG output format (`-Tfig`) supports up to 512 custom colors. The previous
  limit was 256, after which it would crash (see note in the “Fixed” section).
- **Breaking**: The TCL binding’s `tcldot_layout` function no longer tries to
  fallback to the `dot` layout engine if the requested engine is unavailable but
  instead fails with an error message.
- The TCL binding’s graph `render` command no longer ignores layout errors.
- The TCL binding’s graph `write` command now does layout unconditionally,
  regardless of what output renderer is selected.
- The CMake build system builds cgraph++ and gvc++ as either shared or static
  libraries, respecting the `BUILD_SHARED_LIBS` setting.
- Discovery of the fcntl.h header has been removed from all build systems. This
  header is now unconditionally assumed to exist.
- **Breaking**: `obj_state_t.gradient_frac` is now a `double`.
- **Breaking**: `path.nbox` is now a `size_t`.
- The change described as “Some `routesplines` miscalculations that led to lost
  edges and fatal errors have been avoided” in 11.0.0 has been reverted. The fix
  for this caused other problems.
- **Breaking**: the `d` and `disc` parameters have been removed from
  `Dtcompar_f`.
- CentOS packages are no longer provided.
- In the CMake build system, the minimum required CMake version has been
  increased to 3.14.1.
- **Breaking**: the `disc` parameter has been removed from `Dtfree_f`.
- Gvedit no longer depends on the getopt library.

### Fixed

- The CMake build system now uses absolute paths to PangoCairo libraries during
  linking, resolving build problems on macOS.
- The CMake build system’s path for third-party headers for the DevIL plugin has
  been corrected.
- Edges not rendering properly when using ports and the `crow` arrowhead/tail
  with Windows `Release` builds. #2490
- A duplicate prototype of `aghtmlstr` has been removed.
- `agrelabel_node` (or equivalently, `agrename` when operating on a node) no
  longer corrupts the node-by-id set, causing a crash. This bug was preventing
  `gxl2gv` from processing inputs that used node `name` attributes. #2300
- Accuracy improvements have fixed an assertion failure on macOS. #2538
- The FIG output format (`-Tfig`) no longer crashes when handling more than 256
  colors.
- The `scale` operation implemented by the TCL binding’s tclpathplan scales
  relative to the center of the points being scaled instead of reading
  uninitialized memory.
- The xlib plugin sets “close-on-exec” on the file descriptors it creates,
  preventing them leaking into either web browsers it starts or other processes
  created by the hosting application.
- A sign confusion issue in neatogen’s weighting calculations was fixed. This
  was a regression in Graphviz 11.0.0.
- The CMake build system no longer attaches `dllimport`/`dllexport` annotations
  when compiling static libraries on Windows and MinGW.
- An issue with linking gvpack when building static libraries in the CMake build
  system was fixed.
- An sfdp use-after-free issue was fixed. #2556
- Using `concentrate=true` once again works. This was a regression in Graphviz
  11.0.0. #2559
- `overlap="scale"` no longer causes nodes to be placed on top of one another.
  This was a regression in Graphviz 7.0.5. #2564
- libpack code now understands a cluster to be indicated by the common rules,
  including the “cluster” prefix being case insensitive and the `cluster=true`
  attribute as an alternative. #2187, #2555

## [11.0.0] – 2024-04-28

### Added

- `gv2gml` gained a `-y` option to output the yWorks.com variant of GML instead
  of the default.
- A new command line option, `--filepath=…` has been added to perform the
  function previously served by the `$GV_FILE_PATH` environment variable, use of
  which was removed in Graphviz 6.0.1. Unlike the old `$GV_FILE_PATH` mechanism,
  `--filepath=…` takes effect regardless of the setting of the `$SERVER_NAME`
  environment variable. #2396

### Changed

- `gvpack`, in addition to recognizing a “cluster” name prefix as a mark of a
  cluster, now recognizes this case insensitively as well as recognizing the
  `cluster` attribute. This is more consistent with how the Graphviz libraries
  work.
- **Breaking**: `pkg-config` (.pc) files shipped with Graphviz now include
  `${prefix}/include` in the include path in addition to
  `${prefix}/include/graphviz`. Previously this missing path meant building
  Graphviz demo examples against an installation of Graphviz in a non-system
  path would not work. #2474
- The core PostScript output format (`-Tps`) warns if using an
  out-of-specification font name. To avoid this, use a more sophisticated output
  format like Cairo (`-Tps:cairo`) that does font name lookup and translation.
  #218
- **Breaking**: The libpack functions `putRects`, `packRects`, `putGraphs`,
  `packGraphs`, `packSubgraphs`, `pack_graph`, `shiftGraphs`, `ccomps`,
  `cccomps`, and `pccomps` now take the number of items they are operating on
  (`ng`) as a `size_t`.
- **Breaking**: The `bsearch_cmpf` and `qsort_cmpf` typedefs have been removed.
- `dot -c -v`, when constructing the config6 file, includes comments explaining
  any attempted actions that failed during plugin loading. #2456
- **Breaking**: The `Ndim` global is now a `unsigned short`.
- fdpgen no longer truncates graph names when inferring new names for connected
  component subgraphs.
- **Breaking**: The `nodequeue` type has been removed.
- **Breaking**: The field `Agraphinfo_t.n_nodes` has been removed. The function
  `agnnodes` is a more robust way of retrieving the number of nodes.
- The `-q` command line option will now suppress “no hard-coded metrics…”
  and other font lookup warnings. #2379
- **Breaking**: The `CMP` and `SGN` macros have been removed.
- The CMake build system no longer early-binds all enabled plugins into
  `dot`/`dot.exe`. This early binding was a change introduced in 10.0.1, but was
  not noted in this changelog. Traditionally, of the three Graphviz build
  systems (Autotools, CMake, MS Build), only changes to the Autotools build
  system were noted in this changelog under the assumption that packaging
  ecosystems making use of the other two build systems would need finer grained
  details and would be monitoring the Git commit history instead. This seems to
  not be the case, so in future side-effecting changes to any of the three build
  systems will be included here. #2527, #2528
- The precision of `sep`- and `esep`-based calculations has been improved.
- **Breaking**: Defines `AGRAPH`, `AGNODE`, `AGOUTEDGE`, `AGINEDGE`, and `AGEDGE` are
  replaced with `enum`.
- **Breaking**: The `obj_state_t.url_bsplinemap_poly_n` field is now a `size_t`
  and the `obj_state_t.url_bsplinemap_n` field is now a `size_t *`.
- **Breaking**: The `Ppoly_t.pn` (`Ppolyline_t.pn`) field is now a `size_t`.
- **Breaking**: The `Proutespline` function takes its `n_barriers` parameter as
  a `size_t`.
- **Breaking**: The `gvattr_t` type and the `GVJ_t.selected_obj_attributes` and
  `GVJ_t.selected_obj_type_name` fields have been removed.
- **Breaking**: The `gv_argvlist_t` type and functions that operate on it have
  been removed.
- Control characters in some error messages are escaped, preventing certain
  types of text injection that could cause user confusion.
- **Breaking**: `GVJ_t.numkeys` is a `size_t`.

### Fixed

- Indexing within `gvNextInputGraph` no longer incorrectly retains the index
  from prior use of the GVC context. When using Graphviz libraries
  programmatically, this could previously cause crashes or misbehavior. #2484
- Color schemes, typically controlled through the `colorscheme` attribute are
  now pushed and popped as they are applied and released. Previously processing
  multiple graphs wherein the first uses color schemes but later ones do not
  could result in color schemes being incorrectly retained and reapplied or
  use-after-free memory accesses.
- The GDI+ plugin, when asked to render a graphic metafile, no longer references
  uninitialized memory. This bug was introduced in Graphviz 2.24.0.
- A `free` of an invalid pointer in `edgepaint` was fixed. #2513
- `gvmap` no longer references uninitialized variables when trying to process
  triangles and encountering only 2 points.
- Using the `point` shape in combination with `peripheries=0` no longer causes
  out of bounds memory writes. This was a regression in Graphviz 7.0.0. #2497
- Unsafe use of a dangling pointer in `ccomps` has been removed. This was a
  regression in Graphviz 7.1.0.
- `gvcolor` no longer crashes when processing color names longer than 127
  characters.
- Interleaving calls to `colorxlate` and `gvrender_resolve_color` no longer
  confuse internal caching mechanisms. Callers should now get the correct color
  back.
- The `nop2` layout engine provided by the neato layout plugin is now equivalent
  to `neato -n2` as intended instead of mistakenly being equivalent to
  `nop`/`nop1`/`neato -n1`.
- An off-by-one error in rank installation was corrected. Previously, an unusual
  `rank=same` constraint could cause a crash when installing ranks. #1308
- `gxl2gv` no longer crashes or misbehaves when symlinked to a non-ASCII file
  name. This is a rare scenario that normal users should not encounter.
- `mm2gv` no longer crashes or misbehaves when reading malformed Matrix Market
  files with non-ASCII bytes in the header.
- A stack buffer overflow in `mm2gv` when processing malformed Matrix Market
  files has been fixed.
- The `newrank` attribute is treated as a boolean instead of any value
  (including `"false"`) being coerced into `"true"`. #2521
- Crashes and misbehavior no longer occur when the `sides` attribute contains
  non-ASCII characters.
- Graphviz binaries like `dot.exe` and `neato.exe` no longer crash or misbehave
  when symlinked to a non-ASCII file name on Windows. This is a rare scenario
  that normal users should not encounter.
- GVPR programs that use `tolower` or `toupper` on strings containing non-ASCII
  characters no longer crash. These functions do not lowercase/uppercase
  non-ASCII characters, so users probably still do not want to use non-ASCII
  strings in a GVPR program.
- Some `routesplines` miscalculations that led to lost edges and fatal errors
  have been avoided. #2368
- An inaccuracy involving an edge case when constructing lines within libpack
  has been corrected.
- A bug in the internal heap implementation used in the network simplex
  algorithm has been corrected. This would previously cause certain runs to
  infer incorrect ordering or subtrees. This was a regression in Graphviz
  2.40.0. #2391, #2529
- Compass points may be more accurately placed on the node boundary in some cases.
- A very small random adjustment in the calculation of the space available for
  edge routing around ellipse shaped nodes in fdp and neato layouts, has been
  removed.
- Incorrect edge splines for ellipse shaped nodes with ports using fdp or
  neato. #2168
- Incorrect edge splines for ellipse and polygon shaped nodes with ports and
  large penwidths using fdp or neato, causing the same symptoms as #2168.
- Incorrect edge splines for polygon shaped nodes with ports more than one
  periphery using fdp or neato, causing the same symptoms as #2168.
- Adjust the space available for edge routing based on penwidth when
  using fdp or neato and `splines=ortho`.
- Setting "mindist" graph attribute for circo layout causes GraphViz library to
  crash with "access violation in cgraph.dll" on gvLayout (checked for Windows
  only). #2356

## [10.0.1] – 2024-02-11

### Added

- Releases now include packages for [Rocky Linux](https://rockylinux.org/) 8 and
  9.
- A new output format, `-Tsvg_inline`, has been added to generate a header-less
  SVG suitable for inlining into HTML. #2285
- The functionality of the `acyclic`, `tred` and `unflatten` command line tools
  are now exposed via the `graphviz_acyclic`, `graphviz_tred` and
  `graphviz_unflatten` API functions in libcgraph. #2194
- `graphviz_node_induce` is available as a new API function in cgraph.h.
- `tred` gained a `-o` command line option to redirect its output to a file.

### Changed

- The Criterion unit tests have been removed and migrated to Pytest. This is
  primarily relevant to downstream packagers of Graphviz. #2443
- **Breaking**: `Dtdisc_t.memoryf` and its associated macros has been removed.
- **Breaking**: The `Dt_t.type` field has been removed.
- **Breaking**: The `dtfound`, `DT_FOUND`, `dtleast`, and `dtmost` macros have
  been removed.
- The nrtmain.c test program has been removed from the portable tarball.
- The TCL Graphviz packages for inter-release versions/snapshots report
  themselves as `<next release>b<internal number>` instead of
  `<next release>~dev.<internal number>`. This fixes a problem wherein TCL would
  see `~dev` as being invalid characters to appear in a version. #2370
- Support for discovering Lua via `lua-config*` has been removed from the
  Autotools build system.
- Lua discovery in the Autotools build system should now respect the location of
  your Lua installation and not unconditionally attempt installation into
  `/usr`. #2152
- The GTK plugin is no longer built or distributed. This plugin relies on GTK 2
  and X11. If you use this plugin, please contact the maintainers to let
  them know it is worthwhile re-enabling this and forward porting it to GTK 3/4
  and Wayland. #1848
- In the Autotools build system, `LIBPOSTFIX=` can now be used to suppress `64`
  being appended to the library installation path.
- The `-m` command line option, whose functionality was disabled in Graphviz
  3.0.0, has been removed.
- Man page typography has been slightly improved.
- macOS release artifacts no longer include `vimdot`. This may be restored in
  future. #2423
- macOS release artifacts no longer include `smyrna`. This may be restored in
  future. #2422
- The PDF output format, `-Tpdf`, respects the environment variable
  `$SOURCE_DATE_EPOCH` for overriding `CreationDate` when built against Cairo
  ≥ 1.16.0. #2473
- The legacy C# viewer app is no longer distributed in the portable source
  tarball.
- Graphviz headers no longer define the `FALSE` and `TRUE` constants.
- The Autotools build system no longer supports Darwin 9 (Mac OSX Leopard).
- **Breaking**: `Agraph_t.link` has been split into `Agraph_t.id_link` and
  `Agraph_t.seq_link`. `Agraph_t.g_dict` has been split into `Agraph_t.g_id`
  and `Agraph_t.g_seq`.
- **Breaking**: `gvpropts.n_outgraphs` is now a `size_t`.
- The OCaml bindings have been removed. If you use these bindings, please contact
  the maintainers to notify them of the existence of users.
- **Breaking**: `polygon_t.sides` and `polygon_t.peripheries` are now `size_t`s.
- **Breaking**: liblab_gamut is no longer included in a Graphviz installation.
  This library had no accompanying header, so using it was not easy. If you are
  using this library, please contact the maintainers to notify them of the
  existence of users. #2489
- **Breaking**: `bezier.size` and `splines.size` are now `size_t`s.
- **Breaking**: the gv.i and gv.cpp SWIG inputs are no longer included in a
  Graphviz installation. #2491
- **Breaking**: the `gvrender_engine_t.beziercurve`,
  `gvrender_engine_t.library_shape`, `gvrender_engine_t.polygon`,  and
  `gvrender_engine_t.polyline` callbacks now take the number of points, `n`, as
  a `size_t`.
- **Breaking**: the `AVG` macro has been removed.
- **Breaking**: the `inside_t.s` union member gained members `lastn`, `radius`,
  `last_poly`, `last`, `outp`, `scalex`, `scaley`, `box_URx`, and `box_URy`.
  Zero initialize these when you construct instances of this type. #2498

### Fixed

- The paper size for Doxygen docs generation in the Autotools build system has
  been corrected to `a4`.
- References to `eventf` and `hashf` data structures in the libcdt man page
  have been removed. These data structures were removed in Graphviz 9.0.0.
- References to `DTOFFSET` in the libcdt man page have been removed. This macro
  was removed in Graphviz 2.40.0.
- A number of further updates to the libcdt man page have been made to reflect
  other changes that happened in Graphviz 9.0.0.
- Use of the non-portable `PATH_MAX` constant has been removed. This was a
  regression in Graphviz 7.0.1. In addition to fixing the regression, code has
  been adjusted to remove assumptions on the maximum path length and treat it as
  unbounded. #2452
- Compilation on NetBSD has been repaired. This was a regression in Graphviz
  9.0.0.
- Compilation on SunOS has been repaired. This appears to have been broken since
  the xlib plugin was added some time prior to Graphviz 2.38.0.
- gvpr programs that attempt to close out of range file descriptors no longer
  cause out of bounds memory accesses.
- When large edge weights are used that cause an integer overflow when summing
  them up, Graphviz now gracefully exits with an error message instead of
  crashing. #2450
- Support for the `%n` specifier in `scanf` in gvpr has been restored. This was
  a regression in Graphviz 9.0.0. #2454
