( cd usr/doc/glib-2.86.1 ; rm -rf COPYING )
( cd usr/doc/glib-2.86.1 ; ln -sf LICENSES/LGPL-2.1-or-later.txt COPYING )
( cd usr/lib64 ; rm -rf libgio-2.0.so )
( cd usr/lib64 ; ln -sf libgio-2.0.so.0 libgio-2.0.so )
( cd usr/lib64 ; rm -rf libgio-2.0.so.0 )
( cd usr/lib64 ; ln -sf libgio-2.0.so.0.8600.1 libgio-2.0.so.0 )
( cd usr/lib64 ; rm -rf libgirepository-2.0.so )
( cd usr/lib64 ; ln -sf libgirepository-2.0.so.0 libgirepository-2.0.so )
( cd usr/lib64 ; rm -rf libgirepository-2.0.so.0 )
( cd usr/lib64 ; ln -sf libgirepository-2.0.so.0.8600.1 libgirepository-2.0.so.0 )
( cd usr/lib64 ; rm -rf libglib-2.0.so )
( cd usr/lib64 ; ln -sf libglib-2.0.so.0 libglib-2.0.so )
( cd usr/lib64 ; rm -rf libglib-2.0.so.0 )
( cd usr/lib64 ; ln -sf libglib-2.0.so.0.8600.1 libglib-2.0.so.0 )
( cd usr/lib64 ; rm -rf libgmodule-2.0.so )
( cd usr/lib64 ; ln -sf libgmodule-2.0.so.0 libgmodule-2.0.so )
( cd usr/lib64 ; rm -rf libgmodule-2.0.so.0 )
( cd usr/lib64 ; ln -sf libgmodule-2.0.so.0.8600.1 libgmodule-2.0.so.0 )
( cd usr/lib64 ; rm -rf libgobject-2.0.so )
( cd usr/lib64 ; ln -sf libgobject-2.0.so.0 libgobject-2.0.so )
( cd usr/lib64 ; rm -rf libgobject-2.0.so.0 )
( cd usr/lib64 ; ln -sf libgobject-2.0.so.0.8600.1 libgobject-2.0.so.0 )
( cd usr/lib64 ; rm -rf libgthread-2.0.so )
( cd usr/lib64 ; ln -sf libgthread-2.0.so.0 libgthread-2.0.so )
( cd usr/lib64 ; rm -rf libgthread-2.0.so.0 )
( cd usr/lib64 ; ln -sf libgthread-2.0.so.0.8600.1 libgthread-2.0.so.0 )

# Handle the incoming configuration files:
config() {
  for infile in $1; do
    NEW="$infile"
    OLD="`dirname $NEW`/`basename $NEW .new`"
    # If there's no config file by that name, mv it over:
    if [ ! -r $OLD ]; then
      mv $NEW $OLD
    elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
      # toss the redundant copy
      rm $NEW
    fi
    # Otherwise, we leave the .new copy for the admin to consider...
  done
}

# Prepare the new configuration files
for file in etc/profile.d/libglib2.csh.new etc/profile.d/libglib2.sh.new ; do
  if test -e $(dirname $file)/$(basename $file .new) ; then
    if [ ! -x $(dirname $file)/$(basename $file .new) ]; then
      chmod 644 $file
     else
      chmod 755 $file
    fi
  fi
  config $file
done

# Try to run these.  If they fail, no biggie.
chroot . /usr/bin/glib-compile-schemas /usr/share/glib-2.0/schemas/ 1> /dev/null 2> /dev/null
chroot . /usr/bin/gio-querymodules /usr/lib64/gio/modules/ 1> /dev/null 2> /dev/null

