#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/profile.d/freetype.csh.new
config etc/profile.d/freetype.sh.new
( cd usr/include ; rm -rf freetype )
( cd usr/include ; ln -sf freetype2 freetype )
( cd usr/lib64 ; rm -rf libfreetype.so )
( cd usr/lib64 ; ln -sf libfreetype.so.6.20.4 libfreetype.so )
( cd usr/lib64 ; rm -rf libfreetype.so.6 )
( cd usr/lib64 ; ln -sf libfreetype.so.6.20.4 libfreetype.so.6 )
