#!/bin/bash
config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config usr/share/vim/vimrc.new

# Responding to a report that in some cases the file
# /usr/share/vim/vim90/defaults.vim must be edited in order to change settings
# (some settings in the file will otherwise override those in
# /usr/share/vim/vimrc), we will support a file in the same directory named
# defaults.vim.custom. If this file exists, then it will replace the shipped
# version of defaults.vim. The original file will be preserved as
# defaults.vim.orig.
if [ -r usr/share/vim/vim90/defaults.vim.custom ]; then
  cp -a usr/share/vim/vim90/defaults.vim usr/share/vim/vim90/defaults.vim.orig
  cp -a usr/share/vim/vim90/defaults.vim.custom usr/share/vim/vim90/defaults.vim
fi
( cd usr/bin ; rm -rf eview )
( cd usr/bin ; ln -sf vim eview )
( cd usr/bin ; rm -rf evim )
( cd usr/bin ; ln -sf vim evim )
( cd usr/bin ; rm -rf rview )
( cd usr/bin ; ln -sf vim rview )
( cd usr/bin ; rm -rf rvim )
( cd usr/bin ; ln -sf vim rvim )
( cd usr/bin ; rm -rf view )
( cd usr/bin ; ln -sf vim view )
( cd usr/bin ; rm -rf vimdiff )
( cd usr/bin ; ln -sf vim vimdiff )
( cd usr/doc/vim-9.1.1869 ; rm -rf doc )
( cd usr/doc/vim-9.1.1869 ; ln -sf /usr/share/vim/vim91 doc )
( cd usr/man/da.ISO8859-1/man1 ; rm -rf ex.1.gz )
( cd usr/man/da.ISO8859-1/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/da.ISO8859-1/man1 ; rm -rf rview.1.gz )
( cd usr/man/da.ISO8859-1/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/da.ISO8859-1/man1 ; rm -rf rvim.1.gz )
( cd usr/man/da.ISO8859-1/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/da.ISO8859-1/man1 ; rm -rf view.1.gz )
( cd usr/man/da.ISO8859-1/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/da.UTF-8/man1 ; rm -rf ex.1.gz )
( cd usr/man/da.UTF-8/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/da.UTF-8/man1 ; rm -rf rview.1.gz )
( cd usr/man/da.UTF-8/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/da.UTF-8/man1 ; rm -rf rvim.1.gz )
( cd usr/man/da.UTF-8/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/da.UTF-8/man1 ; rm -rf view.1.gz )
( cd usr/man/da.UTF-8/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/da/man1 ; rm -rf ex.1.gz )
( cd usr/man/da/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/da/man1 ; rm -rf rview.1.gz )
( cd usr/man/da/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/da/man1 ; rm -rf rvim.1.gz )
( cd usr/man/da/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/da/man1 ; rm -rf view.1.gz )
( cd usr/man/da/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/de.ISO8859-1/man1 ; rm -rf ex.1.gz )
( cd usr/man/de.ISO8859-1/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/de.ISO8859-1/man1 ; rm -rf rview.1.gz )
( cd usr/man/de.ISO8859-1/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/de.ISO8859-1/man1 ; rm -rf rvim.1.gz )
( cd usr/man/de.ISO8859-1/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/de.ISO8859-1/man1 ; rm -rf view.1.gz )
( cd usr/man/de.ISO8859-1/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/de.UTF-8/man1 ; rm -rf ex.1.gz )
( cd usr/man/de.UTF-8/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/de.UTF-8/man1 ; rm -rf rview.1.gz )
( cd usr/man/de.UTF-8/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/de.UTF-8/man1 ; rm -rf rvim.1.gz )
( cd usr/man/de.UTF-8/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/de.UTF-8/man1 ; rm -rf view.1.gz )
( cd usr/man/de.UTF-8/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/de/man1 ; rm -rf ex.1.gz )
( cd usr/man/de/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/de/man1 ; rm -rf rview.1.gz )
( cd usr/man/de/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/de/man1 ; rm -rf rvim.1.gz )
( cd usr/man/de/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/de/man1 ; rm -rf view.1.gz )
( cd usr/man/de/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/fr.ISO8859-1/man1 ; rm -rf ex.1.gz )
( cd usr/man/fr.ISO8859-1/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/fr.ISO8859-1/man1 ; rm -rf rview.1.gz )
( cd usr/man/fr.ISO8859-1/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/fr.ISO8859-1/man1 ; rm -rf rvim.1.gz )
( cd usr/man/fr.ISO8859-1/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/fr.ISO8859-1/man1 ; rm -rf view.1.gz )
( cd usr/man/fr.ISO8859-1/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/fr.UTF-8/man1 ; rm -rf ex.1.gz )
( cd usr/man/fr.UTF-8/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/fr.UTF-8/man1 ; rm -rf rview.1.gz )
( cd usr/man/fr.UTF-8/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/fr.UTF-8/man1 ; rm -rf rvim.1.gz )
( cd usr/man/fr.UTF-8/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/fr.UTF-8/man1 ; rm -rf view.1.gz )
( cd usr/man/fr.UTF-8/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/fr/man1 ; rm -rf ex.1.gz )
( cd usr/man/fr/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/fr/man1 ; rm -rf rview.1.gz )
( cd usr/man/fr/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/fr/man1 ; rm -rf rvim.1.gz )
( cd usr/man/fr/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/fr/man1 ; rm -rf view.1.gz )
( cd usr/man/fr/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/it.ISO8859-1/man1 ; rm -rf ex.1.gz )
( cd usr/man/it.ISO8859-1/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/it.ISO8859-1/man1 ; rm -rf rview.1.gz )
( cd usr/man/it.ISO8859-1/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/it.ISO8859-1/man1 ; rm -rf rvim.1.gz )
( cd usr/man/it.ISO8859-1/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/it.ISO8859-1/man1 ; rm -rf view.1.gz )
( cd usr/man/it.ISO8859-1/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/it.UTF-8/man1 ; rm -rf ex.1.gz )
( cd usr/man/it.UTF-8/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/it.UTF-8/man1 ; rm -rf rview.1.gz )
( cd usr/man/it.UTF-8/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/it.UTF-8/man1 ; rm -rf rvim.1.gz )
( cd usr/man/it.UTF-8/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/it.UTF-8/man1 ; rm -rf view.1.gz )
( cd usr/man/it.UTF-8/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/it/man1 ; rm -rf ex.1.gz )
( cd usr/man/it/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/it/man1 ; rm -rf rview.1.gz )
( cd usr/man/it/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/it/man1 ; rm -rf rvim.1.gz )
( cd usr/man/it/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/it/man1 ; rm -rf view.1.gz )
( cd usr/man/it/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/ja/man1 ; rm -rf ex.1.gz )
( cd usr/man/ja/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/ja/man1 ; rm -rf rview.1.gz )
( cd usr/man/ja/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/ja/man1 ; rm -rf rvim.1.gz )
( cd usr/man/ja/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/ja/man1 ; rm -rf view.1.gz )
( cd usr/man/ja/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/man1 ; rm -rf ex.1.gz )
( cd usr/man/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/man1 ; rm -rf rview.1.gz )
( cd usr/man/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/man1 ; rm -rf rvim.1.gz )
( cd usr/man/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/man1 ; rm -rf view.1.gz )
( cd usr/man/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/pl.ISO8859-2/man1 ; rm -rf ex.1.gz )
( cd usr/man/pl.ISO8859-2/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/pl.ISO8859-2/man1 ; rm -rf rview.1.gz )
( cd usr/man/pl.ISO8859-2/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/pl.ISO8859-2/man1 ; rm -rf rvim.1.gz )
( cd usr/man/pl.ISO8859-2/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/pl.ISO8859-2/man1 ; rm -rf view.1.gz )
( cd usr/man/pl.ISO8859-2/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/pl.UTF-8/man1 ; rm -rf ex.1.gz )
( cd usr/man/pl.UTF-8/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/pl.UTF-8/man1 ; rm -rf rview.1.gz )
( cd usr/man/pl.UTF-8/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/pl.UTF-8/man1 ; rm -rf rvim.1.gz )
( cd usr/man/pl.UTF-8/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/pl.UTF-8/man1 ; rm -rf view.1.gz )
( cd usr/man/pl.UTF-8/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/pl/man1 ; rm -rf ex.1.gz )
( cd usr/man/pl/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/pl/man1 ; rm -rf rview.1.gz )
( cd usr/man/pl/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/pl/man1 ; rm -rf rvim.1.gz )
( cd usr/man/pl/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/pl/man1 ; rm -rf view.1.gz )
( cd usr/man/pl/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/ru.KOI8-R/man1 ; rm -rf ex.1.gz )
( cd usr/man/ru.KOI8-R/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/ru.KOI8-R/man1 ; rm -rf rview.1.gz )
( cd usr/man/ru.KOI8-R/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/ru.KOI8-R/man1 ; rm -rf rvim.1.gz )
( cd usr/man/ru.KOI8-R/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/ru.KOI8-R/man1 ; rm -rf view.1.gz )
( cd usr/man/ru.KOI8-R/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/ru.UTF-8/man1 ; rm -rf ex.1.gz )
( cd usr/man/ru.UTF-8/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/ru.UTF-8/man1 ; rm -rf rview.1.gz )
( cd usr/man/ru.UTF-8/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/ru.UTF-8/man1 ; rm -rf rvim.1.gz )
( cd usr/man/ru.UTF-8/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/ru.UTF-8/man1 ; rm -rf view.1.gz )
( cd usr/man/ru.UTF-8/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/tr.ISO8859-9/man1 ; rm -rf ex.1.gz )
( cd usr/man/tr.ISO8859-9/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/tr.ISO8859-9/man1 ; rm -rf rview.1.gz )
( cd usr/man/tr.ISO8859-9/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/tr.ISO8859-9/man1 ; rm -rf rvim.1.gz )
( cd usr/man/tr.ISO8859-9/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/tr.ISO8859-9/man1 ; rm -rf view.1.gz )
( cd usr/man/tr.ISO8859-9/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/tr.UTF-8/man1 ; rm -rf ex.1.gz )
( cd usr/man/tr.UTF-8/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/tr.UTF-8/man1 ; rm -rf rview.1.gz )
( cd usr/man/tr.UTF-8/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/tr.UTF-8/man1 ; rm -rf rvim.1.gz )
( cd usr/man/tr.UTF-8/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/tr.UTF-8/man1 ; rm -rf view.1.gz )
( cd usr/man/tr.UTF-8/man1 ; ln -sf vim.1.gz view.1.gz )
( cd usr/man/tr/man1 ; rm -rf ex.1.gz )
( cd usr/man/tr/man1 ; ln -sf vim.1.gz ex.1.gz )
( cd usr/man/tr/man1 ; rm -rf rview.1.gz )
( cd usr/man/tr/man1 ; ln -sf vim.1.gz rview.1.gz )
( cd usr/man/tr/man1 ; rm -rf rvim.1.gz )
( cd usr/man/tr/man1 ; ln -sf vim.1.gz rvim.1.gz )
( cd usr/man/tr/man1 ; rm -rf view.1.gz )
( cd usr/man/tr/man1 ; ln -sf vim.1.gz view.1.gz )
