#!/bin/bash
config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config usr/share/ghostscript/10.06.0/Resource/Init/cidfmap.new
( cd usr/doc/ghostscript-10.06.0 ; rm -rf doc )
( cd usr/doc/ghostscript-10.06.0 ; ln -sf /usr/share/ghostscript/10.06.0/doc doc )
( cd usr/lib64 ; rm -rf libgs.so )
( cd usr/lib64 ; ln -sf libgs.so.10.06 libgs.so )
( cd usr/lib64 ; rm -rf libgs.so.10 )
( cd usr/lib64 ; ln -sf libgs.so.10.06 libgs.so.10 )
( cd usr/lib64 ; rm -rf libijs.so )
( cd usr/lib64 ; ln -sf libijs-0.35.so libijs.so )
( cd usr/man/man1 ; rm -rf eps2eps.1.gz )
( cd usr/man/man1 ; ln -sf ps2ps.1.gz eps2eps.1.gz )
( cd usr/man/man1 ; rm -rf gsbj.1.gz )
( cd usr/man/man1 ; ln -sf gslp.1.gz gsbj.1.gz )
( cd usr/man/man1 ; rm -rf gsdj.1.gz )
( cd usr/man/man1 ; ln -sf gslp.1.gz gsdj.1.gz )
( cd usr/man/man1 ; rm -rf gsdj500.1.gz )
( cd usr/man/man1 ; ln -sf gslp.1.gz gsdj500.1.gz )
( cd usr/man/man1 ; rm -rf gslj.1.gz )
( cd usr/man/man1 ; ln -sf gslp.1.gz gslj.1.gz )
( cd usr/man/man1 ; rm -rf ps2pdf12.1.gz )
( cd usr/man/man1 ; ln -sf ps2pdf.1.gz ps2pdf12.1.gz )
( cd usr/man/man1 ; rm -rf ps2pdf13.1.gz )
( cd usr/man/man1 ; ln -sf ps2pdf.1.gz ps2pdf13.1.gz )
( cd usr/man/man1 ; rm -rf ps2pdf14.1.gz )
( cd usr/man/man1 ; ln -sf ps2pdf.1.gz ps2pdf14.1.gz )
