config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# Keep same perms on rc.serial.new:
if [ -e etc/rc.d/rc.serial ]; then
  cp -a etc/rc.d/rc.serial etc/rc.d/rc.serial.new.incoming
  cat etc/rc.d/rc.serial.new > etc/rc.d/rc.serial.new.incoming
  mv etc/rc.d/rc.serial.new.incoming etc/rc.d/rc.serial.new
fi

config etc/rc.d/rc.serial.new
config etc/rc.d/rc.setterm.new
config etc/serial.conf.new

for configfile in chfn.new chsh.new login.new remote.new runuser.new runuser-l.new su.new su-l.new ; do
  if [ -r etc/pam.d/$configfile ]; then
    config etc/pam.d/$configfile
  fi
done

if [ -r etc/default/su.new ]; then
  config etc/default/su.new
fi

# Since libmount has dropped all support for an /etc/mtab file, if we find that
# we'll need to replace it with a symlink to /proc/mounts:
if [ ! -L etc/mtab ]; then
  rm -f etc/mtab
  ( cd etc ; ln -sf /proc/mounts mtab )
fi

( cd lib64 ; rm -rf libblkid.so.1 )
( cd lib64 ; ln -sf libblkid.so.1.1.0 libblkid.so.1 )
( cd lib64 ; rm -rf libfdisk.so.1 )
( cd lib64 ; ln -sf libfdisk.so.1.1.0 libfdisk.so.1 )
( cd lib64 ; rm -rf libmount.so.1 )
( cd lib64 ; ln -sf libmount.so.1.1.0 libmount.so.1 )
( cd lib64 ; rm -rf libsmartcols.so.1 )
( cd lib64 ; ln -sf libsmartcols.so.1.1.0 libsmartcols.so.1 )
( cd lib64 ; rm -rf libuuid.so.1 )
( cd lib64 ; ln -sf libuuid.so.1.3.0 libuuid.so.1 )
( cd sbin ; rm -rf clock )
( cd sbin ; ln -sf hwclock clock )
( cd sbin ; rm -rf mount )
( cd sbin ; ln -sf ../bin/mount mount )
( cd sbin ; rm -rf umount )
( cd sbin ; ln -sf ../bin/umount umount )
( cd usr/bin ; rm -rf getopt )
( cd usr/bin ; ln -sf ../../bin/getopt getopt )
( cd usr/bin ; rm -rf i386 )
( cd usr/bin ; ln -sf setarch i386 )
( cd usr/bin ; rm -rf lastb )
( cd usr/bin ; ln -sf last lastb )
( cd usr/bin ; rm -rf linux32 )
( cd usr/bin ; ln -sf setarch linux32 )
( cd usr/bin ; rm -rf linux64 )
( cd usr/bin ; ln -sf setarch linux64 )
( cd usr/bin ; rm -rf more )
( cd usr/bin ; ln -sf ../../bin/more more )
( cd usr/bin ; rm -rf readprofile )
( cd usr/bin ; ln -sf ../sbin/readprofile readprofile )
( cd usr/bin ; rm -rf setterm )
( cd usr/bin ; ln -sf ../../bin/setterm setterm )
( cd usr/bin ; rm -rf uname26 )
( cd usr/bin ; ln -sf setarch uname26 )
( cd usr/bin ; rm -rf x86_64 )
( cd usr/bin ; ln -sf setarch x86_64 )
( cd usr/lib64 ; rm -rf libblkid.so )
( cd usr/lib64 ; ln -sf ../../lib64/libblkid.so.1 libblkid.so )
( cd usr/lib64 ; rm -rf libfdisk.so )
( cd usr/lib64 ; ln -sf ../../lib64/libfdisk.so.1 libfdisk.so )
( cd usr/lib64 ; rm -rf liblastlog2.so )
( cd usr/lib64 ; ln -sf liblastlog2.so.2.0.0 liblastlog2.so )
( cd usr/lib64 ; rm -rf liblastlog2.so.2 )
( cd usr/lib64 ; ln -sf liblastlog2.so.2.0.0 liblastlog2.so.2 )
( cd usr/lib64 ; rm -rf libmount.so )
( cd usr/lib64 ; ln -sf ../../lib64/libmount.so.1 libmount.so )
( cd usr/lib64 ; rm -rf libsmartcols.so )
( cd usr/lib64 ; ln -sf ../../lib64/libsmartcols.so.1 libsmartcols.so )
( cd usr/lib64 ; rm -rf libuuid.so )
( cd usr/lib64 ; ln -sf ../../lib64/libuuid.so.1 libuuid.so )
( cd usr/man/man8 ; rm -rf clock.8.gz )
( cd usr/man/man8 ; ln -sf hwclock.8.gz clock.8.gz )
( cd usr/sbin ; rm -rf cfdisk )
( cd usr/sbin ; ln -sf ../../sbin/cfdisk cfdisk )
( cd usr/sbin ; rm -rf ctrlaltdel )
( cd usr/sbin ; ln -sf ../../sbin/ctrlaltdel ctrlaltdel )
( cd usr/sbin ; rm -rf fdformat )
( cd usr/sbin ; ln -sf ../bin/fdformat fdformat )
( cd usr/sbin ; rm -rf sfdisk )
( cd usr/sbin ; ln -sf ../../sbin/sfdisk sfdisk )
( cd usr/share/bash-completion/completions ; rm -rf lastb )
( cd usr/share/bash-completion/completions ; ln -sf last lastb )
